/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug;

import frc.emul.api.ui.IDisplay;
import frc.emul.api.ui.IDisplayContext;
import frc.emul.mc6809.MC6809;
import frc.emul.vectrex.Vectrex;
import frc.emul.vectrex.VectrexMemory;

public class VectrexAddons {
    public static final byte JVE_HEADER = 17;
    public static final byte[] JVE_ENABLE = "ParaJVE".getBytes();
    public static final int FUNC_RESET_CYCLES = 56065;
    public static final int FUNC_SHOW_CYCLES = 56066;
    public static final int FUNC_PAUSE = 56067;
    public static final int FUNC_MEMDUMP = 56068;
    public static final int FUNC_SNAPSHOT = 56069;
    private final Vectrex vectrex;
    private final byte[] data;
    private IDisplay display;
    private int dataCount;
    private int dataReadAddr;
    private boolean enabled;
    private VectrexMemory mem;
    private MC6809 cpu;
    private long[] cycles;
    private long cycleTag;

    public VectrexAddons(Vectrex vectrex) {
        this.vectrex = vectrex;
        this.data = new byte[128];
    }

    public void setDisplay(IDisplay iDisplay) {
        this.display = iDisplay;
    }

    public synchronized boolean handleIllegalInstruction() {
        this.mem = this.vectrex.getMemory();
        this.cpu = this.vectrex.getCPU();
        if (!this.dataReset()) {
            return false;
        }
        boolean bl = this.enabled;
        if (!bl) {
            this.enabled = bl = this.f_enable();
        } else {
            switch (this.readU16()) {
                case 56065: {
                    bl = this.f_resetCycles();
                    break;
                }
                case 56066: {
                    bl = this.f_showCycles();
                    break;
                }
                default: {
                    this.dataReadAddr = this.cpu.getCurrentPC() + 1;
                    bl = this.f_enable();
                }
            }
        }
        if (bl) {
            this.cpu.getRegisters().setPC(this.dataReadAddr);
        }
        return bl;
    }

    private boolean dataReset() {
        this.dataCount = 0;
        this.dataReadAddr = this.cpu.getCurrentPC();
        return this.readU8() == 17;
    }

    private boolean dataFill(int n) {
        this.dataCount = 0;
        return n < 0 ? true : this.dataAppend(n);
    }

    /*
     * Unable to fully structure code
     */
    private boolean dataAppend(int var1_1) {
        block2: {
            var2_2 = var1_1 - this.dataCount;
            if (var2_2 > this.data.length) {
                return false;
            }
            if (var2_2 <= 0) break block2;
            if (this.mem.canRead(this.dataReadAddr, var2_2)) ** GOTO lbl8
            return false;
lbl-1000:
            // 1 sources

            {
                this.data[this.dataCount++] = (byte)this.mem.readS8(this.dataReadAddr++);
lbl8:
                // 2 sources

                ** while (var1_1-- > 0)
            }
        }
        return true;
    }

    private int readU16() {
        if (this.mem.canRead(this.dataReadAddr, 2)) {
            int n = this.dataReadAddr;
            this.dataReadAddr = n + 2;
            return this.mem.readU16(n);
        }
        return -1;
    }

    private int readU8() {
        if (this.mem.canRead(this.dataReadAddr, 1)) {
            return this.mem.readU8(this.dataReadAddr++);
        }
        return -1;
    }

    private String readStr() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = this.readU8();
        while (n > 0) {
            stringBuffer.append((char)n);
            n = this.readU8();
        }
        return n < 0 ? null : stringBuffer.toString();
    }

    public IDisplayContext getDisplayContext() {
        return this.display == null ? null : this.display.getContext();
    }

    private boolean f_enable() {
        if (!this.dataFill(JVE_ENABLE.length)) {
            return false;
        }
        int n = JVE_ENABLE.length;
        while (n-- > 0) {
            if (this.data[n] == JVE_ENABLE[n]) continue;
            return false;
        }
        return this.dataReadAddr <= 32768 || this.dataReadAddr >= 57344;
    }

    private boolean f_resetCycles() {
        this.cycleTag = this.cpu.getCycles();
        return true;
    }

    private boolean f_showCycles() {
        long l;
        IDisplayContext iDisplayContext = this.getDisplayContext();
        if (iDisplayContext == null) {
            return true;
        }
        long l2 = l = this.cpu.getCycles() - this.cycleTag;
        int n = this.readU8();
        if (n < 0) {
            return false;
        }
        if (n > 0) {
            if (this.cycles == null || this.cycles.length != n) {
                this.cycles = new long[n];
                int n2 = this.cycles.length;
                while (n2-- > 0) {
                    this.cycles[n2] = l;
                }
            } else {
                int n3 = this.cycles.length;
                while (n3-- > 1) {
                    this.cycles[n3] = this.cycles[n3 - 1];
                    l2 += this.cycles[n3];
                }
                this.cycles[0] = l;
                l2 /= (long)this.cycles.length;
            }
        }
        iDisplayContext.setDebugText("Cycles = " + l2);
        return true;
    }
}

